000002100703       //  Maximum length of IFS records is 32740 chars
000003100703       //  Records will be terminated by the windows-style CR/LF sequence
000004100703       //  Character fields are enclosed within double quotes (")
000005100703       //    and trailing blanks are removed
000006160606       //  Numeric fields are output as-is.
000007160606       //  Date fields are output with leading ' so Excel treats them as text
000008100423
000009160607       Ctl-Opt DftActGrp(*No) Option(*SrcStmt: *NoDebugIO);
000010100701
000011100701       // Standard IBM supplied Open Access definitions
000012151122      /copy ExtraSrc,qrnopenacc
000013121028
000014121028       // Definition of template for additional handler parameter
000015121028       //   and related constants.
000016160607      /copy ExtraSrc,ifs_cpy2f
000017121028
000018100701       // Standard IBM supplied IFS prototypes
000019100422      /copy qsysinc/qrpglesrc,ifs
000020121028
000021100703       // RPG Status code values
000022151122      /copy ExtraSrc,monstatcds
000023100422
000030100701
000031160607       Dcl-Pi OAHNDIFS2F ExtPgm('OAHNDIFS2F');
000032160607         info  likeds(QrnOpenAccess_T);
000033160616       End-Pi;
000034100706
000035121028       // The following structures are all mapped via pointers supplied
000036121028       //   in the DS (info) passed from RPG.
000037121028
000038121028       // Field Names/Values structures
000039160607       Dcl-Ds  nvInput likeds(QrnNamesValues_T) based(info.namesValues);
000041100703
000042121028         // Structure to map the "additional information" parameter passed
000043121028         //   by the RPG program. In this case it contains the IFS file name.
000044121028         //   Pointer is contained within the userArea field in the info struct
000045160607       Dcl-Ds  ifs_info likeds(ifs_hdlr_info_t) based(info.userArea);
000047100701
000048121028         // Used by the IFS routines to determine which IFS file is to be used
000049121028         //   Maps to storage dynamically allocated when opening the file.
000050121028         //   Pointer is stored in the rpgStatus field in the info structure
000051160606         // Also contains the seelcted column heading type for the file
000052160606
000053160607       Dcl-Ds  fileState  Qualified based(info.stateInfo);
000054160607         fileHandle   Int(10);
000055160607         headingType  Char(1);
000056160616       End-Ds;
000057160606
000058160606       // Used to map field name (system_Column_Name) to desired heading
000059160606       //   Array is populated during file open and referenced by write ops.
000060160606
000061160607       Dcl-Ds  column_names Qualified Dim(100);
000062160607         system_Column_Name  Char(10);
000064160607         column_Name         Char(128);
000065160607         column_Heading      Char(60);
000067160616       End-Ds;
000068160606
000069100422
000070100703       If info.rpgOperation = QrnOperation_WRITE;
000071100703
000072100703         // Write error is unlikely but signal it if it occurs
000073160607         If writeFile(fileState) = ioError;
000074111022           dsply ('Error on IFS file write');
000075100703           info.rpgStatus = errIO;
000076100703         EndIf;
000077100703
000078100701       elseIf info.rpgOperation = QrnOperation_OPEN;
000079100703         // Specify that we want to use Name/Value intformation
000080100703         info.useNamesValues = *On;
000081100703
000082100703         // Allocate the storage for the file handle and store the pointer
000083100703         //   in the info area. That way RPG can associate the pointer with
000084100703         //   the specific file and give it back to us on each operation.
000085160607         info.stateInfo = %Alloc(%Size(fileState));
000086100703
000087100703         // Ensure that file handle is zero before attempting open()
000088160607         clear fileState.fileHandle;
000089100703
000090160607         fileState = openFile (ifs_info); // Open file
000091160607         if fileState.fileHandle = fileNotOpen;
000092111022           dsply ('Error - Failed to open IFS file');
000093100701           info.rpgStatus = errImpOpenClose; // Open failed
000094100701         EndIf;
000095100703
000096100703       elseif info.rpgOperation = QrnOperation_CLOSE;
000097160607         closeFile (fileState.fileHandle);
000098100703
000099100703         // free the state information and null out the info pointer
000100121028         dealloc(n) info.stateInfo;
000101100703         info.stateInfo = *null;
000102100703
000103100701       else;
000104100703         // Any other operation is unsupported so notify RPG
000105111022         dsply ('Error - Unsupported operation - code (' +
000106111022         %Char(info.rpgOperation) + ')' );
000107111022         info.rpgStatus = 1299;  // general error status
000108100422       endif;
000109100701
000110100701       Return;
000111100701
000112100701
000113100422
000114160607       Dcl-Proc  openFile;
000115160607       Dcl-Pi    openFile  likeDS(fileState);
000116160607         fileInfo          likeDS(ifs_hdlr_info_t) Const;
000118160616       End-Pi;
000119100701
000120160607       Dcl-Ds  state  likeDS(fileState);
000121121027
000122160606
000123160607       // Set heading type from input request and set into state info for file
000124160606
000125160607       If ( fileInfo.headingType = Field ) or
000126160607          ( fileInfo.headingType = Heading ) or
000127160607          ( fileInfo.headingType = Name );
000128160607          state.headingType = fileInfo.headingType;
000129160607       Else;
000130160607          state.headingType = None; // Default to no heading row
000131160607       EndIf;
000132160606
000133160607       state.fileHandle = open( fileInfo.path
000134160607                              :  O_CREAT + O_WRONLY + O_CCSID + O_TRUNC
000135160607                               + O_TEXTDATA + O_TEXT_CREAT
000136160607                              : S_IRUSR + S_IWUSR + S_IRGRP + S_IROTH
000137160607                              : 1208
000138160607                              : 0 );
000139121027
000140160607       return state;
000141121027
000143160607       End-Proc  openFile;
000144100422
000145160607
000146160607       Dcl-Proc  closeFile;
000147160607       Dcl-Pi    closeFile;
000148160607         handle  like(fileState.fileHandle);
000149160616       End-Pi;
000150160607
000151160607       Dcl-S  rc  Int(10);
000152100703
000154160607       rc = close (handle);
000155100703
000158160607       End-Proc  closeFile;
000159100422
000160160607       Dcl-Proc  writeFile;
000161160607       Dcl-Pi    writeFile  Int(10);
000162160607         fileInfo  likeDS(fileState);
000163160616       End-Pi;
000164100701
000165121027       // Buffer length is arbitrary but 32K should be big enough
000166160607       Dcl-S  buffer         Varchar(32740) Inz;
000168160607       Dcl-S  headingBuffer  Varchar(32740) Inz;
000169160607
000170151122       // Field value storage currently limited to 1K but can be expanded
000171160607       Dcl-S  value          Char(1024) Based(pvalue);
000172160607       Dcl-S  fieldValue     Varchar(1024);
000173160606
000174160607       Dcl-S  fieldName      Char(10);
000175160607
000176160607       Dcl-S  sqlText        Char(1000);
000177160607       Dcl-S  columnName     Varchar(200);
000178160606
000179151122
000180160607       Dcl-S  i              Int(5);
000181160607       Dcl-S  f              Int(5);
000182160607       Dcl-S  reply          Int(10);
000183160607       Dcl-C  comma          ',';
000184160607       Dcl-C  apost          '''';
000185160607       Dcl-C  quote          '"';
000186160607       Dcl-C  CRLF           x'0d25';
000187160607
000188100701
000189160607       // Load column heading information for file from SYSCOLUMNS
000190160607       //   Note: Not required if column heading type = F(ield)
000191160607       //         as we will already have the field name
000192160607       If ( fileInfo.headingType <> None ) and ( fileInfo.headingType <>
000193160607         Field ) ;
000194160607
000195160607         sqlText = 'select system_column_name, column_name, column_headi+
000196160607         ng from qsys2/syscolumns where table_schema = ' + apost +
000197160607         %Trim(info.externalFile.library ) + apost + ' and table_name = '
000198160607          + apost + %Trim(info.externalFile.name ) + apost +
000199160607         ' order by system_column_name';
000200160607
000201160607         exec sql Prepare getColumnInfo from :sqlText;
000202160607
000203160607         exec sql Declare columnData Cursor for getColumnInfo;
000204160607
000205160607         exec sql open columnData;
000206160607
000207160607         exec sql Fetch next from columnData for 100 rows into :
000208160607         column_Names;
000209160607
000210160607         exec sql close columnData;
000211160607
000212160607       EndIf;
000213160607
000214100703       // Process all fields in record
000215160606
000216100703       For i = 1 to nvInput.num;
000217160607
000218160607         fieldName = nvInput.field(i).externalName; // Copy current name for later use
000219160607         If fileInfo.headingType <> None;
000220160607
000221160607           If fileInfo.headingType = Field;
000222160607             columnName = %TrimR(fieldName); // Use field name
000223160607           Else;
000224160607             f = %Lookup( fieldName: column_names(*).system_Column_Name);
000225160607
000226160607             If fileInfo.headingType = Heading;
000227160607               columnName = %TrimR(column_names(f).column_Heading);
000228160607             ElseIf fileInfo.headingType = Name; // Replace underscores in name
000229160607               columnName = %TrimR( %ScanRpl('_': ' ': column_names(f)
000230160607               .column_Name));
000231160607             EndIf;
000232160607
000233160607           EndIf;
000234160607
000235160607           headingBuffer += quote + columnName + quote;
000236160607
000237160607           If i <> nvInput.num;
000238160607             headingBuffer += comma;
000239160607           Else;
000240160607             headingBuffer += CRLF;
000241160607             reply = write ( fileInfo.fileHandle : %Addr(headingBuffer:
000242160607             *Data) : %Len(headingBuffer) );
000243160607             fileInfo.headingType = None;  // Set headings to none as they are done
000244160607           EndIf;
000245160607         EndIf;
000246160607
000247100703         pvalue = nvInput.field(i).value; // set up to access data
000248151122         // Copy trimmed value to temporary field storage
000249151122         fieldValue = %trimR( %subst( value: 1: nvInput.field(i)
000250151122         .valueLenBytes ));
000251100703
000252100703         If ( nvInput.field(i).dataType = QrnDatatype_Alpha ) Or (
000253100703           nvInput.field(i).dataType = QrnDatatype_AlphaVarying);
000254151122           buffer += quote + fieldValue + quote;
000255100703
000256100703         ElseIf ( nvInput.field(i).dataType = QrnDatatype_Decimal );
000257151122           buffer += fieldValue;
000258100703
000259100703         ElseIf ( nvInput.field(i).dataType = QrnDatatype_Date );
000260160606           buffer += apost + fieldValue;
000261100703
000262100703         EndIf;
000263100703
000264100703         If i <> nvInput.num; // Add comma after every field except the last
000265100703           buffer += comma;
000266100703         EndIf;
000267100703
000268100703       EndFor;
000269100703
000270100703       buffer += CRLF; // Add record termination
000271100703
000272100703       // reply will contain the length of data written or -1 in case of error
000273160607       reply = write ( fileInfo.fileHandle: %Addr(buffer:*Data):
000274160607       %Len(buffer) );
000275100703
000276100703       Return reply;
000277100703
000278160607       End-Proc  writeFile;
000279100703
