000100100703
000200100703      //  Maximum length of IFS records is 32740 chars
000300100703      //  Records will be terminated by the windows-style CR/LF sequence
000400100703      //  Character fields are enclosed within double quotes (")
000500100703      //    and trailing blanks are removed
000600160606      //  Numeric fields are output as-is.
000700160606      //  Date fields are output with leading ' so Excel treats them as text
000800100423
000900100703     H DftActGrp(*No) Option(*SrcStmt)
001000100701
001100100701       // Standard IBM supplied Open Access definitions
001200151122      /copy ExtraSrc,qrnopenacc
001300121028
001400121028       // Definition of template for additional handler parameter
001500121028       //   and related constants.
001600160606      /copy ExtraSrc,ifs_cpy2
001700121028
001800100701       // Standard IBM supplied IFS prototypes
001900100422      /copy qsysinc/qrpglesrc,ifs
002000121028
002100100703       // RPG Status code values
002200151122      /copy ExtraSrc,monstatcds
002300100422
002400100703      // On V7 and later systems this PR can be removed and so can those for
002500100703      //   local subprocedures openFile(), writeFile() and closeFile().
002600160622     D OA_HND_IFS2     Pr                  ExtPgm('OAHNDIFS2')
002700100703     D   info                              likeds(QrnOpenAccess_T)
002800100703
002900100701
003000160607     D OA_HND_IFS2     PI
003100100706     D   info                              likeds(QrnOpenAccess_T)
003200100706
003300121028       // The following structures are all mapped via pointers supplied
003400121028       //   in the DS (info) passed from RPG.
003500121028
003600121028       // Field Names/Values structures
003700100703     D nvInput         ds                  likeds(QrnNamesValues_T)
003800121028     D                                     based(info.namesValues)
003900100703
004000121028       // Structure to map the "additional information" parameter passed
004100121028       //   by the RPG program. In this case it contains the IFS file name.
004200121028       //   Pointer is contained within the userArea field in the info struct
004300100422     D ifs_info        ds                  likeds(ifs_hdlr_info_t)
004400121028     D                                     based(info.userArea)
004500100701
004600121028       // Used by the IFS routines to determine which IFS file is to be used
004700121028       //   Maps to storage dynamically allocated when opening the file.
004800121028       //   Pointer is stored in the rpgStatus field in the info structure
004900160606       // Also contains the seelcted column heading type for the file
005000160606
005100160607     D fileState       ds                  Qualified based(info.stateInfo)
005200160606     D   fileHandle                  10i 0
005300160606     D   headingType                  1a
005400160606
005500160606       // Used to map field name (system_Column_Name) to desired heading
005600160606       //   Array is populated during file open and referenced by write ops.
005700160606
005800160606     D column_names    ds                  Qualified Dim(100)
005900160606     D   system_Column_Name...
006000160606     D                               10a
006100160606     D   column_Name                128a
006200160606     D   column_Heading...
006300160606     D                               60a
006400160606
006500100422      /free
006600100422
006700100703         If info.rpgOperation = QrnOperation_WRITE;
006800100703
006900100703            // Write error is unlikely but signal it if it occurs
007000160607            If writeFile(fileState) = ioError;
007100111022               dsply ('Error on IFS file write');
007200100703               info.rpgStatus = errIO;
007300100703            EndIf;
007400100703
007500100701         elseIf info.rpgOperation = QrnOperation_OPEN;
007600100703            // Specify that we want to use Name/Value intformation
007700100703            info.useNamesValues = *On;
007800100703
007900100703            // Allocate the storage for the file handle and store the pointer
008000100703            //   in the info area. That way RPG can associate the pointer with
008100100703            //   the specific file and give it back to us on each operation.
008200160607            info.stateInfo = %Alloc(%Size(fileState));
008300100703
008400100703            // Ensure that file handle is zero before attempting open()
008500160607            clear fileState.fileHandle;
008600100703
008700160607            fileState = openFile (ifs_info); // Open file
008800160607            if fileState.fileHandle = fileNotOpen;
008900111022              dsply ('Error - Failed to open IFS file');
009000100701              info.rpgStatus = errImpOpenClose; // Open failed
009100100701            EndIf;
009200100703
009300100703         elseif info.rpgOperation = QrnOperation_CLOSE;
009400160607            closeFile (fileState.fileHandle);
009500100703
009600100703            // free the state information and null out the info pointer
009700121028            dealloc(n) info.stateInfo;
009800100703            info.stateInfo = *null;
009900100703
010000100701         else;
010100100703            // Any other operation is unsupported so notify RPG
010200111022           dsply ('Error - Unsupported operation - code ('
010300111022                  + %Char(info.rpgOperation) + ')' );
010400111022           info.rpgStatus = 1299;  // general error status
010500100422         endif;
010600100701
010700100701       Return;
010800100701
010900100422      /end-free
011000100701
011100100422
011200100422     P openFile        b
011300160606     D openFile        pi                  likeDS(fileState)
011400160607     D   fileInfo                          likeDS(ifs_hdlr_info_t)
011500100422     D                                     const
011600100701
011700160606     D state           ds                  likeDS(fileState)
011800121027
011900100422      /free
012000160606
012100160606         // Set heading type from input request and set into state info for file
012200160606
012300160606         If ( fileInfo.headingType = Field ) or
012400160606            ( fileInfo.headingType = Heading ) or
012500160607            ( fileInfo.headingType = Name );
012600160607            state.headingType = fileInfo.headingType;
012700160606         Else;
012800160606            state.headingType = None; // Default to no heading row
012900160607         EndIf;
013000160606
013100160607         state.fileHandle = open( fileInfo.path
013200160607                                :  O_CREAT + O_WRONLY + O_CCSID + O_TRUNC
013300160607                                 + O_TEXTDATA + O_TEXT_CREAT
013400160607                                : S_IRUSR + S_IWUSR + S_IRGRP + S_IROTH
013500160607                                : 1208
013600160607                                : 0 );
013700121027
013800160607         return state;
013900121027
014000100422      /end-free
014100100701
014200100422     P openFile        e
014300100422
014400100422     P closeFile       b
014500100422     D closeFile       pi
014600160607     D   handle                            like(fileState.fileHandle)
014700160607
014800100422     D rc              s             10i 0
014900100703
015000100422      /free
015100100703
015200160607         rc = close (handle);
015300100703
015400100422      /end-free
015500100701
015600100701
015700100422     P closeFile       e
015800100422
015900100703     P writeFile       b
016000160607     D                 pi            10i 0
016100160607     D   fileInfo                          likeDS(fileState)
016200100701
016300121027       // Buffer length is arbitrary but 32K should be big enough
016400100703     D buffer          s          32740a   Varying Inz
016500151122
016600160607     D headingBuffer   s          32740a   Varying Inz
016700160607
016800151122       // Field value storage currently limited to 1K but can be expanded
016900151122     D value           s           1024a   Based(pvalue)
017000151122     D fieldValue      s           1024a   Varying
017100160606
017200160607     D fieldName       s             10a
017300160607
017400160607     D sqlText         s           1000a
017500160607     D columnName      s            200a   Varying
017600160606
017700151122
017800100703     D i               s              5i 0
017900160607     D f               s              5i 0
018000100703     D reply           s             10i 0
018100100703     D comma           c                   ','
018200160606     D apost           c                   ''''
018300100703     D quote           c                   '"'
018400100703     D CRLF            c                   x'0d25'
018500160607
018600100701
018700100422      /free
018800160607         // Load column heading information for file from SYSCOLUMNS
018900160607         //   Note: Not required if column heading type = F(ield)
019000160607         //         as we will already have the field name
019100160607         If ( fileInfo.headingType <> None ) and
019200160607            ( fileInfo.headingType <> Field ) ;
019300160607
019400160607            sqlText = 'select system_column_name, column_name, +
019500160607                          column_heading +
019600160607                          from qsys2/syscolumns where table_schema = '
019700160607                          + apost + %Trim(info.externalFile.library ) + apost
019800160607                          + ' and table_name = '
019900160607                          + apost + %Trim(info.externalFile.name ) + apost
020000160607                          + ' order by system_column_name';
020100160607
020200160607            exec sql Prepare getColumnInfo from :sqlText;
020300160607
020400160607            exec sql Declare columnData Cursor for  getColumnInfo;
020500160607
020600160607            exec sql open columnData;
020700160607
020800160607            exec sql Fetch next from columnData
020900160607                           for 100 rows
021000160607                           into :column_Names;
021100160607
021200160607            exec sql close columnData;
021300160607
021400160607         EndIf;
021500160607
021600100703       // Process all fields in record
021700160606
021800100703       For i = 1 to nvInput.num;
021900160607
022000160607         fieldName = nvInput.field(i).externalName; // Copy current name for later use
022100160607         If fileInfo.headingType <> None;
022200160607
022300160607            If fileInfo.headingType = Field;
022400160607               columnName = %TrimR(fieldName); // Use field name
022500160607            Else;
022600160607               f = %Lookup( fieldName: column_names(*).system_Column_Name);
022700160607
022800160607               If fileInfo.headingType = Heading;
022900160607                  columnName =  %TrimR(column_names(f).column_Heading);
023000160607               ElseIf fileInfo.headingType = Name; // Replace underscores in name
023100160607                  columnName =
023200160607                    %TrimR( %ScanRpl('_': ' ': column_names(f).column_Name));
023300160607               EndIf;
023400160607
023500160607            EndIf;
023600160607
023700160607            headingBuffer += quote + columnName + quote;
023800160607
023900160607            If i <> nvInput.num;
024000160607               headingBuffer += comma;
024100160607            Else;
024200160607               headingBuffer += CRLF;
024300160607               reply = write ( fileInfo.fileHandle
024400160607                      : %Addr(headingBuffer:*Data)
024500160607                      : %Len(headingBuffer) );
024600160607               fileInfo.headingType = None;  // Set headings to none as they are done
024700160607            EndIf;
024800160607         EndIf;
024900160607
025000100703         pvalue = nvInput.field(i).value; // set up to access data
025100151122         // Copy trimmed value to temporary field storage
025200151122         fieldValue
025300151122            = %trimR( %subst( value: 1: nvInput.field(i).valueLenBytes ));
025400100703
025500100703         If ( nvInput.field(i).dataType = QrnDatatype_Alpha )
025600100703         Or ( nvInput.field(i).dataType = QrnDatatype_AlphaVarying);
025700151122           buffer += quote + fieldValue + quote;
025800100703
025900100703         ElseIf ( nvInput.field(i).dataType = QrnDatatype_Decimal );
026000151122           buffer += fieldValue;
026100100703
026200100703         ElseIf ( nvInput.field(i).dataType = QrnDatatype_Date );
026300160606           buffer += apost + fieldValue;
026400100703
026500100703         EndIf;
026600100703
026700100703         If i <> nvInput.num; // Add comma after every field except the last
026800100703           buffer += comma;
026900100703         EndIf;
027000100703
027100100703       EndFor;
027200100703
027300100703       buffer += CRLF; // Add record termination
027400100703
027500100703       // reply will contain the length of data written or -1 in case of error
027600160607       reply = write ( fileInfo.fileHandle: %Addr(buffer:*Data): %Len(buffer) );
027700100703
027800100703       Return reply;
027900100703
028000100422      /end-free
028100100703     P writeFile       e
028200100510
