000100180620       // Program DIYAJL2
000101180620       //
000102180620       //  Secondary program to accompany the DATA-INTO YAJL article published in
000103180620       //    the June 2018 Extra article YAJL Meets DATA-INTO
000104180620       //    http://ibmsystemsmag.com/ibmi/developer/rpg/yajl-meets-data-into/
000105180620       //
000106180620       //  See DIYAJL1 for the basic use of YAJL. This program (DIYAJL2) shows
000107180620       //    the use of processing options such as specifying character values to
000108180620       //    be used for boolean true/false. It also shows the additions to the
000109180620       //    target DS needed when a name is supplied at the lowest level
000110180620       //    (i.e. to effectively mimic an XML root element).
000112180620       //
000115180620
000116180620       dcl-ds  results Qualified;
000117180620          count_Customers  Int(10);    // We can't use the PSDS count so
000118180620                                       //   we need to add a count field here
000119180603          dcl-ds  Customers  Dim(99);
000120180603             ID      packed(5);
000121180603             Active  char(1);
000122180603             Name    char(30);
000123180603             dcl-ds  Address;
000124180603                Street  char(40);
000125180603                City    char(30);
000126180603                State   char(2);
000127180603                Zip     char(10);
000128180603             end-ds;
000129180603          end-ds;
000130180603       end-ds;
000131180603
000136180602       dcl-s  jsonFile  varchar(200)
000137180603              inz('/home/Paris/Extra/customerData2.json');
000138180602
000139180602       dcl-s  i  int(10);
000140180602       dcl-s  wait  char(1);
000141180602
000142180620       //  Three YAJL options are used here. Values "Y" and "N" are assigned for
000143180620       //    boolean True/false, and a null string is the value for null.
000144180620       //  Note also the use of countprefix=count_ to generate the element
000145180620       //    count that will be placed in count_Customers.
000146180620
000147180603       Data-into  results %Data( jsonFile
000148180603                            : 'doc=file case=any countprefix=count_')
000149180602                  %Parser( 'YAJL/YAJLINTO'
000150180602                         : '{ "value_true": "Y", +
000151180602                             "value_false": "N", +
000152180602                             "value_null": "" }');
000153180602
000154180603       For i = 1 to results.count_Customers;  // Loop through results
000155180603          Dsply ( 'Customer ' + %EditC( results.Customers(i).ID: 'X')
000156180603                + ' Active = ' + results.Customers(i).Active
000157180603                + ' Zip = ' + results.Customers(i).Address.Zip );
000158180602       endfor;
000159180602
000160180603       Dsply ('Processed ' + %Char(results.count_Customers)
000161180603             + ' Customers' ) ' ' wait;
000162180602
000163180602       *InLr = *On;
000164180602
