000100180620       // Program DIYAJL1
000101180620       //
000102180620       //  Main program to accompany the DATA-INTO YAJL article published in
000103180620       //    the June 2018 Extra article YAJL Meets DATA-INTO
000104180620       //    http://ibmsystemsmag.com/ibmi/developer/rpg/yajl-meets-data-into/
000105180620       //
000106180620       //  This is the main version from the article DIYAJL2 demonstrates the
000107180620       //    use of YAJL processing options and how to handle a name at the root
000108180620       //
000109180620
000110180620(A)    dcl-ds  Customers  Dim(99) Qualified;
000111180602          ID      packed(5);
000112180620          Active  ind;         // Using the default of an indicator to map boolean
000113180602          Name    char(30);
000114180603(B)       dcl-ds  Address;
000115180602             Street  char(40);
000116180602             City    char(30);
000117180602             State   char(2);
000118180602             Zip     char(10);
000119180602          end-ds;
000120180602       end-ds;
000121180602
000122180620(C)    dcl-ds *N psds;  // Count in PSDS will tell us hom many elements were filled
000123180602         count Int(20) Pos(372);
000124180602       end-ds;
000125180602
000126180603       dcl-s  jsonFile  varchar(200)
000127180602              inz('/home/Paris/Extra/customerData1.json');
000128180602
000129180603       dcl-s  i     int(10);
000130180603       dcl-s  wait  char(1);
000131180603
000132180603(D)    Data-into  Customers %Data( jsonFile: 'doc=file case=any')
000133180602                  %Parser( 'YAJL/YAJLINTO' );
000134180602
000135180603(E)    For i = 1 to count;  // Loop through results
000136180603          Dsply ( 'Customer ' + %EditC( Customers(i).ID: 'X')
000137180603                + ' Active = ' + Customers(i).Active
000138180603                + ' Zip = ' + Customers(i).Address.Zip );
000139180603       endfor;
000140180603
000141180603       Dsply ('Processed ' + %Char(count) + ' Customers' ) ' ' wait;
000142180603
000143180602       *InLr = *On;
000144180602
